/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.Cell;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.element.AbstractElement;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.Grid;
import net.sourceforge.plantuml.salt.element.LeftFirst;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.element.TopFirst;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementPyramid
extends AbstractElement {
    private int rows;
    private int cols;
    private final TableStrategy tableStrategy;
    private final Map<Element, Cell> positions1;
    private final Map<Cell, Element> positions2 = new HashMap<Cell, Element>();
    private double[] rowsStart;
    private double[] colsStart;

    public ElementPyramid(Positionner2 positionner2, TableStrategy tableStrategy) {
        this.positions1 = positionner2.getAll();
        for (Map.Entry<Element, Cell> object : this.positions1.entrySet()) {
            this.positions2.put(object.getValue(), object.getKey());
        }
        this.rows = positionner2.getNbRows();
        this.cols = positionner2.getNbCols();
        this.tableStrategy = tableStrategy;
        for (Cell cell : this.positions1.values()) {
            this.rows = Math.max(this.rows, cell.getMaxRow());
            this.cols = Math.max(this.cols, cell.getMaxCol());
        }
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        this.init(stringBounder);
        return new Dimension2DDouble(this.colsStart[this.colsStart.length - 1], this.rowsStart[this.rowsStart.length - 1]);
    }

    public void drawU(UGraphic uGraphic, int n, Dimension2D dimension2D) {
        this.init(uGraphic.getStringBounder());
        Grid grid = new Grid(this.rowsStart, this.colsStart, this.tableStrategy);
        for (Map.Entry<Element, Cell> entry : this.positions1.entrySet()) {
            Element element = entry.getKey();
            Cell cell = entry.getValue();
            double d = this.colsStart[cell.getMinCol()];
            double d2 = this.rowsStart[cell.getMinRow()];
            double d3 = this.colsStart[cell.getMaxCol() + 1] - this.colsStart[cell.getMinCol()] - 1.0;
            double d4 = this.rowsStart[cell.getMaxRow() + 1] - this.rowsStart[cell.getMinRow()] - 1.0;
            grid.addCell(cell);
            element.drawU(uGraphic.apply(new UTranslate(d + 1.0, d2 + 1.0)), n, new Dimension2DDouble(d3, d4));
        }
        if (n == 0) {
            grid.drawU(uGraphic, 0.0, 0.0);
        }
    }

    private void init(StringBounder stringBounder) {
        Dimension2D dimension2D;
        Element element;
        if (this.rowsStart != null) {
            return;
        }
        this.rowsStart = new double[this.rows + 1];
        this.colsStart = new double[this.cols + 1];
        ArrayList<Cell> arrayList = new ArrayList<Cell>(this.positions1.values());
        Collections.sort(arrayList, new LeftFirst());
        for (Cell cell : arrayList) {
            element = this.positions2.get(cell);
            dimension2D = element.getPreferredDimension(stringBounder, 0.0, 0.0);
            this.ensureColWidth(cell.getMinCol(), cell.getMaxCol() + 1, dimension2D.getWidth() + 2.0);
        }
        Collections.sort(arrayList, new TopFirst());
        for (Cell cell : arrayList) {
            element = this.positions2.get(cell);
            dimension2D = element.getPreferredDimension(stringBounder, 0.0, 0.0);
            this.ensureRowHeight(cell.getMinRow(), cell.getMaxRow() + 1, dimension2D.getHeight() + 2.0);
        }
    }

    private void ensureColWidth(int n, int n2, double d) {
        double d2 = this.colsStart[n2] - this.colsStart[n];
        double d3 = d - d2;
        if (d3 > 0.0) {
            int n3 = n2;
            while (n3 < this.colsStart.length) {
                int n4 = n3++;
                this.colsStart[n4] = this.colsStart[n4] + d3;
            }
        }
    }

    private void ensureRowHeight(int n, int n2, double d) {
        double d2 = this.rowsStart[n2] - this.rowsStart[n];
        double d3 = d - d2;
        if (d3 > 0.0) {
            int n3 = n2;
            while (n3 < this.rowsStart.length) {
                int n4 = n3++;
                this.rowsStart[n4] = this.rowsStart[n4] + d3;
            }
        }
    }

    public final int getNbRows() {
        return this.rows + 1;
    }

    public final int getNbCols() {
        return this.cols + 1;
    }
}

