# Generated by default/object.tt
package Paws::GreengrassV2::ComponentConfigurationUpdate;
  use Moose;
  has Merge => (is => 'ro', isa => 'Str', request_name => 'merge', traits => ['NameInRequest']);
  has Reset => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'reset', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::ComponentConfigurationUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::ComponentConfigurationUpdate object:

  $service_obj->Method(Att1 => { Merge => $value, ..., Reset => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::ComponentConfigurationUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->Merge

=head1 DESCRIPTION

Contains information about a deployment's update to a component's
configuration on Greengrass core devices. For more information, see
Update component configurations
(https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html)
in the I<AWS IoT Greengrass V2 Developer Guide>.

=head1 ATTRIBUTES


=head2 Merge => Str

A serialized JSON string that contains the configuration object to
merge to target devices. The core device merges this configuration with
the component's existing configuration. If this is the first time a
component deploys on a device, the core device merges this
configuration with the component's default configuration. This means
that the core device keeps it's existing configuration for keys and
values that you don't specify in this object. For more information, see
Merge configuration updates
(https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update)
in the I<AWS IoT Greengrass V2 Developer Guide>.


=head2 Reset => ArrayRef[Str|Undef]

The list of configuration nodes to reset to default values on target
devices. Use JSON pointers to specify each node to reset. JSON pointers
start with a forward slash (C</>) and use forward slashes to separate
the key for each level in the object. For more information, see the
JSON pointer specification (https://tools.ietf.org/html/rfc6901) and
Reset configuration updates
(https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update)
in the I<AWS IoT Greengrass V2 Developer Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

