
package Paws::GlueDataBrew::ListJobs;
  use Moose;
  has DatasetName => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'datasetName');
  has MaxResults => (is => 'ro', isa => 'Int', traits => ['ParamInQuery'], query_name => 'maxResults');
  has NextToken => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'nextToken');
  has ProjectName => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'projectName');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListJobs');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/jobs');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::GlueDataBrew::ListJobsResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::ListJobs - Arguments for method ListJobs on L<Paws::GlueDataBrew>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListJobs on the
L<AWS Glue DataBrew|Paws::GlueDataBrew> service. Use the attributes of this class
as arguments to method ListJobs.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListJobs.

=head1 SYNOPSIS

    my $databrew = Paws->service('GlueDataBrew');
    my $ListJobsResponse = $databrew->ListJobs(
      DatasetName => 'MyDatasetName',    # OPTIONAL
      MaxResults  => 1,                  # OPTIONAL
      NextToken   => 'MyNextToken',      # OPTIONAL
      ProjectName => 'MyProjectName',    # OPTIONAL
    );

    # Results:
    my $Jobs      = $ListJobsResponse->Jobs;
    my $NextToken = $ListJobsResponse->NextToken;

    # Returns a L<Paws::GlueDataBrew::ListJobsResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/databrew/ListJobs>

=head1 ATTRIBUTES


=head2 DatasetName => Str

The name of a dataset. Using this parameter indicates to return only
those jobs that act on the specified dataset.



=head2 MaxResults => Int

The maximum number of results to return in this request.



=head2 NextToken => Str

A token generated by DataBrew that specifies where to continue
pagination if a previous request was truncated. To get the next set of
pages, pass in the NextToken value from the response object of the
previous page call.



=head2 ProjectName => Str

The name of a project. Using this parameter indicates to return only
those jobs that are associated with the specified project.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListJobs in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

