package Acme::Claude::Shell::Hooks;

use 5.020;
use strict;
use warnings;

use Exporter 'import';
our @EXPORT_OK = qw(safety_hooks);

use Claude::Agent::CLI qw(stop_spinner);
use Claude::Agent::Hook::Matcher;
use Claude::Agent::Hook::Result;

=head1 NAME

Acme::Claude::Shell::Hooks - Safety hooks for Acme::Claude::Shell

=head1 SYNOPSIS

    use Acme::Claude::Shell::Hooks qw(safety_hooks);

    my $hooks = safety_hooks($session);

=head1 DESCRIPTION

Provides PostToolUse hooks for command execution cleanup.

Note: Command approval is handled directly in the tool handler (Tools.pm)
to ensure it happens synchronously before execution.

=cut

sub safety_hooks {
    my ($session) = @_;

    # Tool name pattern - matches mcp__shell-tools__execute_command
    my $execute_cmd_pattern = 'execute_command$';

    return {
        # PostToolUse: Stop spinner after command execution
        PostToolUse => [
            Claude::Agent::Hook::Matcher->new(
                matcher => $execute_cmd_pattern,
                hooks   => [sub {
                    my ($input, $tool_use_id, $context) = @_;
                    # Stop the execution spinner
                    if ($session->_spinner) {
                        stop_spinner($session->_spinner);
                        $session->_spinner(undef);
                    }
                    return Claude::Agent::Hook::Result->proceed();
                }],
            ),
        ],
    };
}

=head1 AUTHOR

LNATION, C<< <email at lnation.org> >>

=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2026 by LNATION.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

1;
