/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.JarLoader;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.UpdateLoader;

public abstract class DatabaseClasses
implements ClassFactory,
ModuleControl {
    private ClassInspector classInspector;
    private JavaFactory javaFactory;
    private UpdateLoader applicationLoader;

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.classInspector = new ClassInspector(this);
        String string = null;
        if (properties != null) {
            string = properties.getProperty("derby.__rt.database.classpath");
        }
        if (string != null) {
            this.applicationLoader = new UpdateLoader(string, this, true, true);
        }
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.compiler.JavaFactory");
    }

    public void stop() {
        if (this.applicationLoader != null) {
            this.applicationLoader.close();
        }
    }

    public final GeneratedClass loadGeneratedClass(String string, ByteArray byteArray) throws StandardException {
        try {
            return this.loadGeneratedClassFromData(string, byteArray);
        }
        catch (LinkageError linkageError) {
            DatabaseClasses.WriteClassFile(string, byteArray, linkageError);
            throw StandardException.newException("XBCM1.S", linkageError, (Object)string);
        }
        catch (VirtualMachineError virtualMachineError) {
            DatabaseClasses.WriteClassFile(string, byteArray, virtualMachineError);
            throw virtualMachineError;
        }
    }

    private static void WriteClassFile(String string, ByteArray byteArray, Throwable throwable) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1, string.length()).concat(".class");
        Object object = Monitor.getMonitor().getEnvironment();
        File file = object instanceof File ? (File)object : null;
        File file2 = FileUtil.newFile(file, string2);
        HeaderPrintWriter headerPrintWriter = Monitor.getStream();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byteArray.getArray(), byteArray.getOffset(), byteArray.getLength());
            fileOutputStream.flush();
            if (throwable != null) {
                headerPrintWriter.printlnWithHeader(MessageService.getTextMessage("C000", string, file2, throwable));
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ClassInspector getClassInspector() {
        return this.classInspector;
    }

    public final Class loadApplicationClass(String string) throws ClassNotFoundException {
        try {
            return this.loadClassNotInDatabaseJar(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.applicationLoader == null) {
                throw classNotFoundException;
            }
            Class clazz = this.applicationLoader.loadClass(string, true);
            if (clazz == null) {
                throw classNotFoundException;
            }
            return clazz;
        }
    }

    protected Class loadClassNotInDatabaseJar(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public final Class loadApplicationClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException {
        return this.loadApplicationClass(objectStreamClass.getName());
    }

    public boolean isApplicationClass(Class clazz) {
        return clazz.getClassLoader() instanceof JarLoader;
    }

    public void notifyModifyJar(boolean bl) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyJar(bl);
        }
    }

    public void notifyModifyClasspath(String string) throws StandardException {
        if (this.applicationLoader != null) {
            this.applicationLoader.modifyClasspath(string);
        }
    }

    public int getClassLoaderVersion() {
        if (this.applicationLoader != null) {
            return this.applicationLoader.getClassLoaderVersion();
        }
        return -1;
    }

    public ByteArray buildSpecificFactory(String string, String string2) throws StandardException {
        ClassBuilder classBuilder = this.javaFactory.newClassBuilder(this, "org.apache.derby.exe.", 17, string2, "org.apache.derby.impl.services.reflect.GCInstanceFactory");
        MethodBuilder methodBuilder = classBuilder.newConstructorBuilder(1);
        methodBuilder.callSuper();
        methodBuilder.methodReturn();
        methodBuilder.complete();
        methodBuilder = null;
        MethodBuilder methodBuilder2 = classBuilder.newMethodBuilder(1, "org.apache.derby.iapi.services.loader.GeneratedByteCode", "getNewInstance");
        methodBuilder2.pushNewStart(string);
        methodBuilder2.pushNewComplete(0);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        methodBuilder2 = null;
        return classBuilder.getClassBytecode();
    }

    protected abstract LoadedGeneratedClass loadGeneratedClassFromData(String var1, ByteArray var2);
}

