BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Exporter Time::HiRes base constant strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.010; 1}) {
    print "Perl 5.010 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.47.
use strict;
use warnings;
use 5.010;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "NewRelic::Agent::FFI interface that doesn't do anything",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Alt-NewRelic-Agent-FFI-Empty",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.010",
  "NAME"             => "Alt::NewRelic::Agent::FFI::Empty",
  "PM"               => {
    "lib/Alt/NewRelic/Agent/FFI/Empty.pm"  => "\$(INST_LIB)/Alt/NewRelic/Agent/FFI/Empty.pm",
    "lib/NewRelic/Agent/FFI.pm"            => "\$(INST_LIB)/NewRelic/Agent/FFI.pm",
    "lib/NewRelic/Agent/FFI/Procedural.pm" => "\$(INST_LIB)/NewRelic/Agent/FFI/Procedural.pm"
  },
  "PREREQ_PM"     => {},
  "TEST_REQUIRES" => {
    "FFI::Platypus" => 0,
    "Test2::V0"     => "0.000060"
  },
  "VERSION" => "0.03",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::Platypus" => 0,
  "Test2::V0"     => "0.000060"
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

# begin inserted by Dist::Zilla::Plugin::Alt 0.07
my $alt = $ENV{PERL_ALT_INSTALL} || '';
$WriteMakefileArgs{DESTDIR} =
  $alt ? $alt eq 'OVERWRITE' ? '' : $alt : 'no-install-alt';
if ( $^O eq 'MSWin32' && $WriteMakefileArgs{DESTDIR} ) {

  # Windows is a precious snowflake that can't handle DESTDIR
  # Caveat: this probably ignores any PREFIX specified by the user
  require Config;
  require File::Spec;
  my @prefix = split /:/, $Config::Config{prefix};
  $WriteMakefileArgs{PREFIX} = File::Spec->catdir( $WriteMakefileArgs{DESTDIR}, @prefix );
  delete $WriteMakefileArgs{DESTDIR};

  # DO NOT DO THIS SORT OF THING
  # THIS IS PRETTY UGLY AND PROBABLY BAD
  # DO AS I SAY AND NOT AS I DO
  package ExtUtils::MM_Any;
  my $orig = \&init_INSTALL;
  *init_INSTALL = sub {
    my ( $self, @args ) = @_;
    delete $self->{ARGS}{INSTALL_BASE} if $self->{ARGS}{PREFIX};
    $self->$orig(@args);
  }
}

# end inserted by Dist::Zilla::Plugin::Alt 0.07
WriteMakefile(%WriteMakefileArgs);