#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerPayments;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerPayments.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerPayments

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerPayments inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsRequestType;
use eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSellerPayments';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsResponseType';
}

#
# input properties
#

=head2 setPagination()

If many payments are available, you may need to call GetSellerPayments
multiple times to retrieve all the data. Each result set is returned as a
page of entries. Use this Pagination information to indicate the maximum
number of entries to retrieve per page (i.e., per call), the page number
to retrieve, and other data.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut
       
sub setPagination {
   my $self   = shift;
   my $pPagination = shift;
   $self->getRequestDataType()->setPagination($pPagination);
}

=head2 setPaymentStatus()

Filter to retrieve only items with the specified payment status (Paid or
Pending). "Pending payments" are payments that Half.com has created but
that have not yet been sent to the seller's financial institution. Pending
payments are typically available once a buyer pays for an order. As
Half.com processes payments by using periodic batch jobs, the
GetSellerPayments response might not include a transaction's payment for
up to 20 minutes after the buyer has paid. You can retrieve pending
payments for the current pay period. Pending payments that have not been
settled yet can also be retrieved for previous pay periods. "Paid
payments" are payments that Half.com processed during previous pay
periods. Paid payments might not appear in the seller's financial
institution account balance until a certain number of days after the
current pay period ends (see the Half.com online help for details). You
can only retrieve paid payments for one previous pay period at a time.

  RequiredInput: Yes
  AllValuesExcept: Canceled
#    Argument: 'ns:RCSPaymentStatusCodeType'

=cut
       
sub setPaymentStatus {
   my $self   = shift;
   my $sPaymentStatus = shift;
   $self->getRequestDataType()->setPaymentStatus($sPaymentStatus);
}

=head2 setPaymentTimeFrom()

Time range filter that retrieves Half.com payments that were created within
a single pay period. Sellers can refer to the Half.com site to determine
their pay periods. PaymentTimeFrom is the earliest (oldest) time and
PaymentTimeTo is the latest (most recent) time in the range. Half.com pay
periods start and end at midnight Pacific time, but the time values are
stored in the database in GMT (not Pacific time). See "Time Values" in the
eBay Web Services guide for information about converting between GMT and
Pacific time. <br>
<br>
If you specify a PaymentStatus of Pending, add a buffer of one hour (or one
day) to both ends of the time range to retrieve more data than you need, and
then filter the results on the client side as needed. If any pending
payments match the request, the response may include all payments since the
beginning of the period. <br>
<br>
If you specify a PaymentStatus of Paid, the time range must contain one
full pay period. That is, PaymentTimeFrom must be earlier or equal the
start time of the pay period, and PaymentTimeTo must be later than or
equal to the end time of the pay period. Otherwise, no paid payments are
returned. For example, if the pay period starts on 2005-09-16 and ends on
2005-09-30, you could specify an earlier PaymentTimeFrom value of
2005-09-16T00:00:00.000Z and a later PaymentTimeTo value of
2005-10-01T12:00:00.000Z. <br>
<br>
If you specify a time range that covers two pay periods, only the payments
from the most recent pay period are returned. The earliest time you can
specify is 18 months ago.

  RequiredInput: Yes
#    Argument: 'xs:dateTime'

=cut
       
sub setPaymentTimeFrom {
   my $self   = shift;
   my $sPaymentTimeFrom = shift;
   $self->getRequestDataType()->setPaymentTimeFrom($sPaymentTimeFrom);
}

=head2 setPaymentTimeTo()

Time range filter that retrieves Half.com payments for a single pay
period. See the description of PaymentTimeTo for details about using this
time range filter. For paid payments, this value should be equal to or
later than the end of the last day of the pay period, where the time is
converted to GMT. For example, if the period ends on 2005-09-30, you could
specify 2005-10-01T09:00:00.000Z, which is later than the end of the last
day.

  RequiredInput: Yes
#    Argument: 'xs:dateTime'

=cut
       
sub setPaymentTimeTo {
   my $self   = shift;
   my $sPaymentTimeTo = shift;
   $self->getRequestDataType()->setPaymentTimeTo($sPaymentTimeTo);
}



#
# output properties
#

=head2 isHasMorePayments()

If true, there are more payments yet to be retrieved. Additional
GetSellerPayments calls with higher page numbers or more entries per page
must be made to retrieve these payments. If false, no more payments are
available or no payments match the request (based on the payment status
and time filter).

  Returned: Always
#    Returns: 'xs:boolean'

=cut
       
sub isHasMorePayments {
   my $self = shift;
   return $self->getResponseDataType()->isHasMorePayments();
}

=head2 getPageNumber()

Indicates which page of data holds the current result set. Will be the
same as the value specified in the Pagination.PageNumber input. (If the
input is higher than the total number of pages, the call fails with an
error.) If no payments are returned, the value is 0. If payments are
returned, the first page number is 1.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getPageNumber {
   my $self = shift;
   return $self->getResponseDataType()->getPageNumber();
}

=head2 getPaginationResult()

Contains information regarding the pagination of data (if pagination is used),
including total number of pages and total number of entries.

  Returned: Always
#    Returns: 'ns:PaginationResultType'

=cut
       
sub getPaginationResult {
   my $self = shift;
   return $self->getResponseDataType()->getPaginationResult();
}

=head2 getPaymentsPerPage()

Indicates the number of payments that can be returned per page of data
(i.e., per call). This is the same as the value specified in the
Pagination.EntriesPerPage input (or the default value, if EntriesPerPage
was not specified). This is not necessarily the actual number of payments
returned per page (see ReturnedPaymentCountActual).

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getPaymentsPerPage {
   my $self = shift;
   return $self->getResponseDataType()->getPaymentsPerPage();
}

=head2 getReturnedPaymentCountActual()

Indicates the total number of payments returned (i.e., the number of
SellerPayment entries returned.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getReturnedPaymentCountActual {
   my $self = shift;
   return $self->getResponseDataType()->getReturnedPaymentCountActual();
}

=head2 getSellerPayment()

Information about a single payment that matches the criteria in the
request. A payment is between Half.com and a seller. Each payment is for
one transaction for one item in one order. An order can contain
transactions for multiple items from multiple sellers, but this call only
retrieves payments that are relevant to one seller. The financial value of
a payment is typically based on an amount that a buyer paid to Half.com
for a transaction, plus the shipping cost the buyer paid for the item,
minus Half.com's commission. Payments can also describe refunds that the
seller has issued. Multiple SellerPayment entries can be returned per page
of results. Typically, they are returned in reverse chronological order
(most recent PaidTime first). Only returned if payments exist that match
the request.

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:SellerPaymentType'

=cut
       
sub getSellerPayment {
   my $self = shift;
   return $self->getResponseDataType()->getSellerPayment();
}





1;   
