# Generated by default/object.tt
package Paws::FraudDetector::ExternalEventsDetail;
  use Moose;
  has DataAccessRoleArn => (is => 'ro', isa => 'Str', request_name => 'dataAccessRoleArn', traits => ['NameInRequest'], required => 1);
  has DataLocation => (is => 'ro', isa => 'Str', request_name => 'dataLocation', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::ExternalEventsDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::ExternalEventsDetail object:

  $service_obj->Method(Att1 => { DataAccessRoleArn => $value, ..., DataLocation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::ExternalEventsDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->DataAccessRoleArn

=head1 DESCRIPTION

Details for the external events data used for model version training.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DataAccessRoleArn => Str

The ARN of the role that provides Amazon Fraud Detector access to the
data location.


=head2 B<REQUIRED> DataLocation => Str

The Amazon S3 bucket location for the data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

