package WordList::ID::BIP39;

our $DATE = '2018-01-01'; # DATE
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our %STATS = ("longest_word_len",16,"num_words_contains_unicode",0,"num_words_contains_whitespace",0,"avg_word_len",6.31982421875,"num_words",2048,"num_words_contains_nonword_chars",0,"shortest_word_len",4); # STATS

1;
# ABSTRACT: Indonesian (proposed) word list for BIP 39

=pod

=encoding UTF-8

=head1 NAME

WordList::ID::BIP39 - Indonesian (proposed) word list for BIP 39

=head1 VERSION

This document describes version 0.002 of WordList::ID::BIP39 (from Perl distribution WordList-ID-BIP39), released on 2018-01-01.

=head1 SYNOPSIS

 use WordList::ID::BIP39;

 my $wl = WordList::ID::BIP39->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This is the proposed Indonesian word list for BIP 39. The list was formed by
selecting the most common Indonesian words from Wikipedia (see
L<WordLists::ID::Common> repository) that are at least 4 characters long and are
not found in the other BIP 39 wordlists (L<EN|WordList::EN::BIP39>,
L<ES|WordList::ES::BIP39>, L<FR|WordList::FR::BIP39>,
L<FR|WordList::IT::BIP39>). Characteristics of this wordlist:

=over

=item * Selected from most common words (Wikipedia Indonesia corpus).

=item * At least 4 characters long.

=item * Words can be uniquely determined typing the first 4 characters.

=item * Words are not found in the other languages' BIP wordlist, so language detection is easy.

=back

=head1 STATISTICS

 +----------------------------------+---------------+
 | key                              | value         |
 +----------------------------------+---------------+
 | avg_word_len                     | 6.31982421875 |
 | longest_word_len                 | 16            |
 | num_words                        | 2048          |
 | num_words_contains_nonword_chars | 0             |
 | num_words_contains_unicode       | 0             |
 | num_words_contains_whitespace    | 0             |
 | shortest_word_len                | 4             |
 +----------------------------------+---------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ID-BIP39>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ID-BIP39>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ID-BIP39>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

About BIP 39: L<https://github.com/bitcoin/bips/blob/master/bip-0039.mediawiki>

About BIPs (Bitcoin Improvement Proposals): L<https://en.bitcoin.it/wiki/Bitcoin_Improvement_Proposals>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
abad
abjad
absen
abstrak
acak
acara
acuan
adalah
adanya
adaptasi
adat
adegan
adik
adil
adipati
administratif
adonan
agak
agama
agar
agen
agresif
agung
ahli
airnya
ajaib
ajang
ajaran
akademik
akal
akan
akar
akhir
akibat
akrab
akreditasi
aksara
akses
aksi
akta
aktif
aktor
aktris
aktual
akun
akurat
akustik
akut
alam
alasan
alat
albumnya
alias
alih
aliran
alkitab
alkohol
almarhum
alternatif
alumni
alun
alur
amal
aman
amat
ambil
amunisi
anak
analisis
ancaman
anda
aneh
aneka
anggota
angin
angka
animasi
anjing
anonim
antara
anti
anugerah
anumerta
apabila
apakah
apalagi
apapun
apartemen
apel
aplikasi
apresiasi
arah
aransemen
arca
areal
argumen
arkeologi
armada
arsip
artefak
artikel
arus
arwah
asal
asam
asap
asasi
aset
asing
asisten
asli
asosiasi
aspek
aspirasi
asrama
asteroid
astronomi
asuhan
asumsi
asuransi
atap
atas
atau
atlet
atmosfer
atraksi
atribut
aturan
audisi
awak
awal
awam
awan
ayahnya
ayam
ayat
babak
babi
baca
badan
bagaimana
bagian
bagus
bahasa
bahkan
bahu
bahwa
baik
bait
baja
baju
bakar
bakteri
baku
balapan
balik
balok
bambu
band
bangsa
banjir
bank
bantuan
banyak
bapak
barat
baris
baru
basah
basis
batas
baterai
batik
batu
bawah
bayaran
bayi
beasiswa
bebas
beberapa
beda
begitu
bekas
bekerja
beku
belakang
beliau
belum
benar
bencana
bendera
benih
bensin
bentuk
benua
bepergian
berada
berbagai
bercerita
berdasarkan
berencana
berfungsi
bergabung
berhasil
berikut
berjudul
berkembang
berlangsung
bermain
bernama
beroperasi
berperan
bersama
bertemu
berubah
bervariasi
berwarna
besaran
beserta
besi
betapa
betina
beton
betul
biara
biasanya
biaya
bibir
bible
bicara
bidang
bijaksana
biji
bikin
bila
bimbingan
binatang
biner
bingung
bintang
biografi
biologi
bioskop
birokrat
biru
bisa
bisnis
bita
blokir
bobot
bocah
bodoh
boleh
boneka
botol
buah
buang
buatan
buaya
bubar
bubuk
budaya
budi
bukan
bukit
bukti
buku
bulan
bulu
bumbu
bumi
bundar
bunga
bunuh
bunyi
bupati
bursa
burung
busana
busur
buta
butir
butuh
cabang
cacat
cacing
cadangan
cahaya
cairan
cakram
cakupan
calon
campuran
candi
canggih
cantik
caranya
cari
catatan
catur
cedera
celah
cenderung
cepat
cerah
cerdas
cerita
cermin
cerpen
cetak
cikal
cilik
cincin
cintanya
ciptaan
ciri
citra
coba
cocok
cokelat
coklat
contoh
corak
cuaca
cucu
cukup
cuma
curah
dada
daerah
daftar
dagang
daging
dahsyat
dahulu
dakwah
dalam
damai
dampak
dana
dangdut
dapat
dapur
darah
dari
darurat
dasar
data
daun
daur
daya
debat
debut
definisi
degradasi
dekat
deklarasi
delapan
delegasi
demam
demikian
demokrasi
dendam
dengan
denominasi
depan
depresi
derajat
deret
desa
deskripsi
destinasi
detektif
detik
dewasa
dewi
diabadikan
diadakan
diajukan
diakses
dialek
diambil
dianggap
diartikan
diasingkan
diatur
diawali
dibangun
diberikan
dibintangi
diblokir
dibongkar
dibuat
dicatat
dicetak
diciptakan
diculik
didasarkan
didefinisikan
didirikan
didominasi
didukung
diedarkan
dieja
dieksekusi
difilmkan
digantikan
digelar
digit
digolongkan
digunakan
dihasilkan
dihentikan
dihitung
dihormati
dihuni
diidentifikasi
diikuti
diinginkan
diiringi
diisi
diizinkan
dijadikan
dijelaskan
dijual
dikatakan
dikenal
dikhususkan
dikirim
diklasifikasikan
dikonsumsi
dikritik
dikuasai
dilakukan
dilengkapi
dilihat
diluncurkan
dimana
dimensi
dimiliki
dimodifikasi
dimulai
dinamakan
dinding
dingin
dinilai
dinominasikan
dinyatakan
diolah
dioperasikan
dipakai
diperkirakan
dipimpin
diplomatik
dipotong
diproduksi
dipublikasikan
dirancang
diresmikan
diri
dirujuk
disajikan
disebut
disingkat
diskusi
disponsori
distrik
disutradarai
ditayangkan
ditebang
ditinjau
ditolak
ditulis
diubah
diucapkan
diuji
diukur
diumumkan
diundang
diurutkan
diusulkan
diutus
divisi
diwakili
diwujudkan
diyakini
dokter
dokumen
dolar
domba
domestik
dominan
dong
dorongan
dosa
dosen
dramatis
drastis
duduk
duet
dugaan
dukungan
dulu
dunia
durasi
duri
dusun
duta
edisi
efek
efisien
ejaan
ekologi
ekonomi
ekor
ekosistem
eksekutif
eksis
eksklusif
ekspedisi
eksternal
elektronik
elemen
elit
email
emas
emisi
emosi
empat
enak
enam
endemik
energi
enggan
engkau
ensiklopedia
entah
entitas
entri
enzim
erat
esai
etanol
etika
etnis
evaluasi
even
evolusi
faksi
faktor
fakultas
famili
fantasi
fasilitas
favorit
featuring
federasi
fenomena
figur
fiksi
fiktif
filmografi
filosofi
filsafat
filum
finalis
finis
firman
fisik
fitur
fleksibel
flora
fluida
fokus
format
fosil
fotografi
fragmen
fraksi
frasa
frekuensi
fundamental
fungsi
gabungan
gadis
gagal
gaib
gajah
gaji
galaksi
galeri
gambar
gamelan
ganda
gangguan
ganti
garam
garis
gawang
gaya
gedung
gejala
gelar
gelombang
gemar
gembira
gempa
gencatan
gender
generasi
genggam
genus
geografis
geologi
geometri
gerakan
gerbang
gereja
gerilya
gigi
gila
gilirannya
ginjal
gitar
gizi
global
golongan
goreng
grafis
gram
gravitasi
grup
gubernur
gudang
gugatan
gugur
gula
gulungan
guna
gunung
guru
habis
hadapan
hadir
haji
hakim
halaman
halnya
halus
hama
hamba
hamil
hampir
hancur
handal
hangat
hantu
hanya
hapus
harapan
harfiah
harga
hari
harta
harus
hasil
hati
hebat
hektar
helikopter
hendak
heran
hewan
hiasan
hiburan
hidangan
hidrogen
hidup
hijau
hijrah
hilang
hilir
himpunan
hingga
hipotesis
historis
hitam
hobi
homoseksual
horizontal
hormat
horor
hubungan
hujan
hukum
hulu
huruf
hutan
ialah
ibadah
ibukota
ibunya
identitas
ideologi
idola
ikan
ikatan
iklan
iklim
ikon
ikut
ilahi
ilmiah
ilmu
ilustrasi
imam
iman
imbang
imigran
implementasi
impor
inci
indah
independen
individu
indonesia
indra
industri
infeksi
informasi
infrastruktur
ingat
inggris
ingin
inilah
inisiatif
inovasi
insiden
inspirasi
insting
internasional
inti
intro
invasi
investasi
irama
irigasi
isinya
isotop
istana
isteri
istilah
istri
isyarat
itulah
izin
jabatan
jadi
jadwal
jagung
jahat
jajaran
jalan
jalur
jamak
jaminan
jamur
janda
jangan
janji
jantung
jarak
jaringan
jarum
jasa
jati
jatuh
jauh
jawab
jejak
jelas
jemaat
jembatan
jenazah
jenderal
jenis
jenjang
jernih
jeruk
jika
jilid
jingga
jiwa
jual
juara
jubah
judul
juga
jujur
julukan
jumlah
juniornya
juri
jurnal
jurusan
justru
juta
kabar
kabel
kabinet
kabupaten
kaca
kadang
kader
kafir
kaget
kaidah
kain
kaisar
kaitannya
kajian
kakak
kakek
kaki
kaku
kalau
kalender
kali
kalo
kamar
kambing
kamera
kami
kampung
kamu
kanan
kandang
kanji
kanker
kanon
kantor
kapal
kapten
kapur
karakter
karbon
kardinal
karena
kargo
karier
kartu
karunia
karya
kasar
kaset
kasih
kastil
kasus
kata
kategori
kaum
kavaleri
kawasan
kawin
kaya
kayu
keadaan
keagamaan
keahlian
keamanan
keanggotaan
kebanyakan
keberadaan
kebijakan
kebutuhan
kecamatan
kecepatan
kecil
kecuali
kedatangan
kedelapan
kediaman
kedokteran
kedua
keempat
keenam
keesokan
kegagalan
kegelapan
kegiatan
kegunaan
kehadiran
kehendak
kehidupan
kehormatan
keilmuan
keinginan
kejadian
kejuaraan
kekaisaran
kekerasan
kekhawatiran
kekosongan
kekuatan
kelas
kelebihan
kelima
kelompok
keluarga
kemampuan
kembali
kemenangan
kemiskinan
kemudian
kenal
kendaraan
kenegaraan
kental
kenyataan
kepada
kepercayaan
keping
kepolisian
kepribadian
keputusan
kerajaan
kerbau
kereta
kering
kerja
kertas
kerusakan
kesalahan
keseluruhan
kesimpulan
kesulitan
ketat
ketertarikan
ketika
keturunan
keuangan
keuntungan
keuskupan
kewajiban
kewenangan
keyakinan
khalifah
khas
khawatir
khusus
kian
kilometer
kimia
kinerja
kini
kira
kiri
kisah
kita
klaim
klan
klasik
klien
klik
klinik
klip
klorida
klub
koalisi
kode
koin
kokoh
kolam
koleksi
kolonial
komandan
kombinasi
komersial
komik
komoditas
komputer
komunitas
kondisi
koneksi
konflik
kongres
konon
konsep
kontrak
konvensional
koordinasi
koperasi
kopi
koran
korban
koridor
korupsi
kosakata
kosong
kostum
kota
kotor
kreatif
kredit
kriminal
krisis
kritikus
ksatria
kualitas
kuantum
kuasa
kuat
kubah
kubu
kucing
kuda
kudeta
kudus
kuil
kulit
kultur
kumbang
kumpulan
kunci
kuning
kunjungan
kuno
kupu
kurang
kurikulum
kursi
kurun
kutipan
kutub
laba
laboratorium
ladang
laga
lagi
lagu
lahan
lahir
lain
laju
laki
lakukan
lalat
lalu
lama
lambang
lampu
lancar
landasan
langsung
lanjut
lantai
lapangan
lapisan
laporan
larangan
lari
larutan
laser
latar
latihan
laut
lawan
layanan
lazim
lebar
lebih
ledakan
legenda
legislatif
leher
lelaki
leluhur
lemah
lembaga
lempeng
lengkap
lensa
lenyap
lepas
lereng
letaknya
letusan
lewat
liat
liberal
libur
lidah
lihat
lilin
limbah
linear
lingkungan
links
lintas
lipat
lirik
lisan
lisensi
listrik
literatur
liturgi
location
logam
logika
logo
lokal
lokomotif
lolos
lomba
luar
luas
lubang
lucu
luhur
luka
lukisan
lulus
lumayan
lumpur
lunak
lurus
maaf
mabuk
macam
madrasah
madu
mahasiswa
mahir
mahkota
mainan
majalah
majelis
maju
maka
makhluk
makin
makmur
makna
maksud
malam
malu
mamalia
mampu
manajemen
mancanegara
mandiri
manfaat
mangsa
manis
mantan
manusia
marah
marga
maritim
markas
masalah
masih
masjid
maskapai
massa
masuk
masyarakat
matahari
materi
mati
matriks
maupun
mayat
mayoritas
mazhab
medan
medis
megah
meja
mekanisme
melalui
melewati
melihat
melompat
meluncurkan
memakan
membuat
memenangkan
memfasilitasi
memiliki
memotong
mempunyai
memulai
menarik
mencapai
mendapatkan
menerima
menggunakan
meninggal
menjadi
menolak
menteri
menunjukkan
menyebabkan
meraih
merdeka
mereka
merger
merilis
merupakan
mesin
meskipun
mesti
metadata
metode
metropolitan
mewakili
mewujudkan
meyakinkan
migrasi
mikro
militer
mimpi
minat
mineral
minggu
minoritas
minta
minuman
minyak
mirip
misalnya
misi
miskin
misterius
mitologi
mobil
modal
modern
modifikasi
modul
mohon
molekul
momen
monarki
monumen
monyet
motivasi
moyang
muara
muatan
muda
muka
mulai
mulia
multi
mulut
muncul
mundur
mungkin
munisipalitas
murah
murid
murni
musik
muslim
musuh
musyawarah
mutasi
mutlak
mutu
nabi
nada
nafsu
naga
naik
nama
namun
nantinya
napas
narasi
narkoba
nasa
nasional
naskah
natrium
naungan
navigasi
nebula
negara
negeri
negosiasi
nelayan
nenek
neraka
netral
newspaper
niat
nilai
ninja
nirkabel
nitrogen
nominasi
nomor
nuansa
nubuat
nuklir
nusa
nutrisi
nyaman
nyanyian
nyaris
nyata
nyawa
nyeri
obat
objek
obligasi
oksigen
olahraga
oleh
operasi
opini
oposisi
opsi
optik
orang
orbital
ordo
organisasi
orientasi
orkestra
ornamen
otak
otomatis
otonomi
otoritas
otot
pabrik
pacar
pacu
pada
padi
paduan
pagar
pagi
paham
pahit
pahlawan
pajak
pakaian
paket
paksa
paku
paling
palsu
pamannya
pameran
panas
pandangan
panen
panggung
panitia
panjang
pantai
papan
para
pariwisata
parkir
parlemen
paroki
partai
paruh
pasangan
pasca
pasir
pasokan
pasti
pasukan
patah
paten
patroli
patung
paus
payung
pecahan
pecinta
pedagang
pedesaan
pedoman
peduli
pegawai
pegunungan
pejabat
pejuang
pekan
pekerjaan
pelayanan
pelepasan
pelindung
pelopor
peluncuran
pemain
pembangunan
pemerintah
pemimpin
pemrograman
pemuda
penampilan
pencarian
penduduk
penerbangan
pengguna
peningkatan
penjualan
penonton
pensiun
penting
penulis
penyanyi
peperangan
pepohonan
perang
perbedaan
percaya
perdagangan
perempuan
perfilman
pergi
perhatian
periode
perjalanan
perkembangan
perlu
permukaan
pernah
perolehan
perpustakaan
persen
pertama
perusahaan
perwira
pesawat
peserta
pesisir
pesta
petani
peternakan
peti
petunjuk
pewaris
piala
pidato
pihak
pikiran
pilihan
pimpinan
pindah
pinggiran
pinjaman
pintu
piringan
pisau
pita
plastik
plat
plot
plus
pohon
poin
pokok
pola
politik
pondok
ponsel
populer
poros
posisi
potensi
potongan
potret
prajurit
praktik
pranala
prasasti
predator
prefektur
presiden
pria
pribadi
primordial
prinsip
prioritas
produksi
profesional
progresif
promosi
properti
proses
protein
provinsi
proyek
psikologi
puas
publik
pucat
puing
puisi
pujian
pukul
pula
pulih
puluh
punah
puncak
punggung
punk
punya
pupuk
pura
purba
pusat
pustaka
putaran
putera
putih
putra
putus
racun
radius
ragam
ragu
rahasia
raih
raja
rajin
raksasa
rakyat
ramai
rambut
ranah
rancangan
rangka
rantai
rapat
rapi
rasa
rasio
rasul
rating
ratusan
rawa
raya
reaksi
realitas
redaksi
referensi
reformasi
regional
reguler
rekaman
rekor
rekreasi
rektor
relasi
relevan
religius
remaja
rempah
renang
rencana
rendah
renovasi
rentang
reproduksi
republik
reruntuhan
resep
resmi
resolusi
respon
restoran
revisi
revolusi
rezim
ribu
rilis
rincian
ringan
rintisan
riset
risiko
riwayat
roda
rohani
roket
rokok
romantis
rombongan
ronde
rongga
rotasi
roti
ruang
ruas
rudal
rugi
rujukan
rumah
rumit
rumput
rumus
runtuh
rupa
rupiah
rusak
rute
rutin
saat
sabda
sabuk
sadar
saham
sains
saja
sakit
saksi
sakti
salah
saleh
saling
salju
saluran
sama
sambil
sampai
samurai
sana
sandiwara
sangat
sanksi
santri
sapi
sarana
sari
sarjana
sasaran
sastra
satelit
satu
satwa
saudara
saus
sawah
sawit
saya
sayuran
seakan
sebagai
sebesar
sebuah
secara
sedang
sederhana
sedikit
seekor
segala
segera
segi
segmen
sehari
sehingga
sehubungan
seimbang
seiring
sejak
sejenis
sejumlah
sekarang
sekelompok
sekitar
sekolah
sekretaris
seksual
sektor
sekutu
selama
selesai
selisih
seluruh
semakin
sembilan
sementara
seminggu
semoga
sempat
semua
senang
sendiri
sengaja
seni
senjata
sensus
sentral
senyawa
seolah
seorang
sepanjang
seperti
sepuluh
serangan
serba
serentak
sering
serta
serupa
server
sesama
seseorang
sesi
sesuatu
setahun
setelah
setiap
setuju
seumur
sewaktu
siang
siapa
siaran
sibuk
sidang
sifat
signifikan
sihir
sikap
siklus
silat
silinder
silsilah
siluman
simbol
sinar
sinetron
singel
sini
sintesis
sinyal
sipil
sirip
sirkuit
sisa
sisi
sistem
siswa
situs
skala
skandal
skema
skenario
sketsa
skor
soal
solusi
sopan
sore
sosial
sosok
spektrum
spesies
spiritual
spons
stabil
stadion
staf
standar
star
stasiun
status
stop
strategis
string
stroke
struktur
studi
suaminya
suara
suasana
suatu
subjek
subspesies
subur
subyek
suci
sudah
sudut
suhu
suka
sukses
suku
sulit
sultan
sulung
sumber
sumpah
sumur
sungai
suntingan
supaya
support
surat
surel
surga
surut
survei
surya
susah
susu
sutradara
swasta
syair
syarat
syukur
syuting
taat
tabel
tablet
tabung
tadi
tahap
tahta
tahun
tajam
takhta
taksi
taktik
takut
tali
taman
tambahan
tampil
tamu
tanah
tanda
tanggal
tani
tanjung
tanpa
tantangan
tanya
tapi
tari
tata
tatkala
tawaran
tayang
teater
tebal
tebing
tebu
tegas
teguh
tekanan
teknologi
teks
telah
televisi
telinga
telur
teman
tembok
tempat
temurun
tenaga
tendangan
tengah
tentang
teologi
teori
tepat
tepi
tepung
terakhir
terbentuk
tercatat
terdapat
terendah
tergolong
terhadap
terima
terjadi
terkenal
terletak
termasuk
ternyata
terowongan
terpilih
tersebut
tertentu
terutama
terwujud
tetapi
tewas
tiada
tiang
tiap
tiba
tidak
tidur
tiga
tiket
tikus
timah
timbul
timnya
timur
tindakan
tinggi
tinju
tipe
tipis
tiri
titik
tokoh
toleransi
tolong
tombol
tongkat
topeng
topik
tradisional
tragedi
trailer
transportasi
trek
triliun
tropis
truk
tsunami
tuan
tubuh
tuduhan
tugas
tugu
tujuan
tukang
tulang
tulisan
tumbuh
tunai
tunduk
tunggal
tuntutan
turbin
turis
turnamen
turut
tutup
uang
ubah
ubur
ucapan
udang
udara
ujian
ujung
ukiran
ukuran
ulama
ulang
ular
ulasan
umat
umpan
umumnya
umur
undang
unggulan
ungkapan
ungu
unik
universitas
unjuk
unsur
untuk
upacara
upah
upaya
upeti
urusan
urutan
usaha
usai
usia
uskup
usulan
usus
utama
utang
utara
utuh
utusan
vakum
vampir
vandalisme
variasi
vektor
versi
vertikal
visi
vitamin
vokal
vulkanik
wabah
wadah
waduk
wafat
wahana
wahyu
wajah
wajib
wakil
waktu
walaupun
wali
wangsa
wanita
waralaba
warga
warisan
warna
wartawan
warung
wasit
wawancara
wayang
wewenang
wilayah
wisata
wujud
yaitu
yakin
yakni
yang
yatim
yayasan
yurisdiksi
zaman
