/*
 * Decompiled with CFR 0.152.
 */
package be.fivebyfive.lingua.stanfordcorenlp;

import java.util.UUID;

public abstract class PipelineItem {
    protected UUID id = null;
    protected String idStr = "";
    protected static long idLeast = Long.MIN_VALUE;
    protected static long idMost = Long.MIN_VALUE;

    public void setIDFromString(String string) {
        this.id = UUID.nameUUIDFromBytes(string.getBytes());
    }

    public static void initializeCounters(long l, long l2) {
        idLeast = l;
        idMost = l2;
    }

    public static void randomizeCounters() {
        UUID uUID = UUID.randomUUID();
        PipelineItem.initializeCounters(uUID.getLeastSignificantBits(), uUID.getMostSignificantBits());
    }

    public static UUID generateID() {
        if (idLeast <= Long.MAX_VALUE) {
            ++idLeast;
        } else if (idMost <= Long.MAX_VALUE) {
            ++idMost;
        } else {
            System.out.println("PipelineItem.generateID(): ran out of IDs!");
        }
        return new UUID(idMost, idLeast);
    }

    public UUID getID() {
        if (this.id == null) {
            this.id = PipelineItem.generateID();
        }
        return this.id;
    }

    public String getIDString() {
        if (this.idStr.equals("")) {
            this.idStr = this.getID().toString();
        }
        return this.idStr;
    }

    public boolean identicalTo(PipelineItem pipelineItem) {
        return this.getID().equals(pipelineItem.getID());
    }

    public abstract String toCompactString();
}

